// Autoren: Robert Ssemann und Horst Rechner

import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class CartServlet extends HttpServlet
{
	public void doGet (HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		PrintWriter out = response.getWriter();
		// Rckgabe MIME-Type festlegen
		response.setContentType("text/html");

		// aktuelle Session aus Request abfangen, gegebenfalls erzeugen
		HttpSession session = request.getSession(true);

		// in der akt. Session enthaltenes object cart wird in ShoppingCart bernommen
		ShoppingCart cart = (ShoppingCart)session.getValue(session.getId());

		if (cart == null)
		{
			// erzeugt neues cart
			cart = new ShoppingCart();
			// Bindet das Object cart an die aktuelle Session
			session.putValue(session.getId(), cart);
		}

		// HTML-Dateikopf ausgeben
		out.println(
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
			"\n" +

			"<HTML>\n" +
			"	<HEAD>\n" +
			"		<TITLE>CD-Shopping ganz einfach - Einkaufswagen</TITLE>\n" +
			"       <META http-equiv=\"expires\" content=\"0\">\n" +
			"	</HEAD>\n" +
			"\n" +

			"	<BODY bgcolor=\"#2D84A4\" text=\"black\" link=\"white\" vlink=\"white\" alink=\"#2D84A4\">\n" +
			"	<TABLE border=0 width=\"100%\">\n" +
			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" valign=\"middle\"><IMG border=0 height=120 src=\"/cdshop/logo.gif\" width=550></TD>\n" +
			"		</TR>\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n");

		//je nach Filterparameter DB auslesen
		String remove = request.getParameter("remove");

		//Anzeigen aller Artikel im Einkaufswagen
		try
		{
			String url = "jdbc:odbc:cdshopDB";
			Connection con;
			Statement stmt;
			ResultSet rs;

			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			con = DriverManager.getConnection(url, "horst", "horst");

			//Entfernen eines oder aller Artikel
			if(remove != null)
			{
				if (remove.equals("all"))
				{
					cart.clearAll();
					session.putValue(session.getId(), cart);
				}

				else
				{
					Integer removeInt = new Integer(remove);
					cart.removeId(removeInt.intValue());
					session.putValue(session.getId(), cart);
				}
			}

			if (cart.size() == 0)
			{
					out.println(
					"		<TR>\n" +
					"			<TD colspan=6 bgcolor=\"#EDB211\" align=\"center\"><B>Ihr Einkaufswagen ist leer.</B></TD>\n" +
					"       </TR>" +
					"\n");

					out.println(
					"		<TR>\n" +
					"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\"><A href=\"" +
									response.encodeUrl("KatalogServlet?filter=catalog") + "\"><B>Zum Katalog</B></A> | " + "<A href=\"" +
									response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
					"		</TR>\n" +
					"	</TABLE>\n" +
					"	</BODY>\n" +
					"</HTML>\n");
			}

			else
			{
				out.println(
				"		<TR>\n" +
				"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Sie haben " + cart.size() +
				" Artikel in ihrem Einkaufwagen</B></TD>\n" +
				"		</TR>\n" +
				"\n" +

				"		<TR height=20 bgcolor=\"white\">\n" +
				"			<TD align=\"center\">Cover</TD>\n" +
				"			<TD align=\"center\">Titel</TD>\n" +
				"			<TD align=\"center\">Artist</TD>\n" +
				"			<TD align=\"center\">Anzahl</TD>\n" +
				"			<TD align=\"center\">Preis</TD>\n" +
				"			<TD align=\"center\">Entfernen</TD>\n" +
				"		</TR>\n" +
				"\n");

				double gesamtPreis = 0.0;
				double einzelPreis = 0.0;

				for (int i=0; i<cart.size(); i++)
				{
					ShoppingObject myObject = cart.getObject(i);

					stmt = con.createStatement();
					rs = stmt.executeQuery("SELECT id, cover, titel, artist, preis FROM Katalog WHERE id = " + myObject.getId());

					if(rs.next())
					{
						int id = rs.getInt("id");
						String cover = rs.getString("cover");
						String titel = rs.getString("titel");
						String artist = rs.getString("artist");
						double preis = rs.getDouble("preis");

						String enc_url = response.encodeUrl("CartServlet?remove=" + id);

						out.println(
				"		<TR bgcolor=\"silver\">\n" +
				"			<TD align=\"center\" valign=\"middle\"><img src=\"/cdshop/" + cover + "\"></TD>\n" +
				"			<TD align=\"center\" valign=\"middle\">" + titel + "</TD>\n" +
				"			<TD align=\"center\" valign=\"middle\">" + artist + "</TD>\n" +
				"			<TD align=\"center\" valign=\"middle\">" + myObject.getAnzahl() + "</TD>\n" +
				"			<TD align=\"center\" valign=\"middle\">" + preis + " DM</TD>\n" +
				"			<TD align=\"center\" valign=\"middle\"><A href=\"" + enc_url +"\"><B>Entfernen</B></A></TD>\n" +
				"		</TR>\n");

						einzelPreis = preis;
					}

					gesamtPreis += einzelPreis * myObject.getAnzahl();
					rs.close();
					stmt.close();
				}

				// Gesamtsumme und Gesamtpreis ausgeben
				out.println(
				"		<TR bgcolor=\"white\">" +
				"           <TD align=\"center\">Gesamt</TD>" +
				"           <TD colspan=3>&nbsp;</TD>" +
				"			<TD align=\"center\">" + gesamtPreis + " DM</TD>" +
				"           <TD>&nbsp;</TD>" +
				"		</TR>");

				//Links darstellen
				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\"><A href=\"" +
							response.encodeUrl("KatalogServlet?filter=catalog") + "\"><B>Zum Katalog</B></A> | " + "<A href=\"" +
							response.encodeUrl("KasseServlet") + "\"><B>zur Kasse</B></A> | " + "<A href=\"" +
							response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A> | <A href=\"" +
							response.encodeUrl("CartServlet?remove=all") + "\"><B>Alle Artikel entfernen</B></A></TD>\n" +
			"		</TR>\n" +
			"\n");

				out.println(
			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

				//DB-Verbindungen beenden
				con.close();
				//FileWriter beenden
				out.close();
			}

		}

		catch (SQLException ex)
		{
			System.err.println("Fehler bei DB-Verbindung");
			out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\">&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">Fehler bei der DB-Verbindung.\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
    	}

		catch (ClassNotFoundException ex)
		{
			System.err.println("DB-Treiber konnte nicht geladen werden");
			out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\">&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">DB-Treiber konnte nicht geladen werden.</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
		}
    }
}
