// Autor: Horst Rechner

import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DankeServlet extends HttpServlet
{
	public void service (HttpServletRequest request, HttpServletResponse response)
	throws IOException
	{
		PrintWriter out = response.getWriter();
		// Rckgabe MIME-Type festlegen
		response.setContentType("text/html");

		// aktuelle Session aus Request abfangen, gegebenfalls erzeugen
		HttpSession session = request.getSession(true);

		// in der akt. Session enthaltenes object cart wird in ShoppingCart bernommen
		ShoppingCart cart = (ShoppingCart)session.getValue(session.getId());

		// HTML-Dateikopf ausgeben
		out.println(
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
			"\n" +

			"<HTML>\n" +
			"	<HEAD>\n" +
			"		<TITLE>CD-Shopping ganz einfach - Bestellung abgeschickt</TITLE>\n" +
			"       <META http-equiv=\"expires\" content=\"0\">\n" +
			"	</HEAD>\n" +
			"\n" +

			"	<BODY bgcolor=\"#2D84A4\" text=\"black\" link=\"white\" vlink=\"white\" alink=\"#2D84A4\">\n" +
			"	<TABLE border=0 width=\"100%\">\n" +
			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
		  	"			<TD colspan=6 align=\"center\" valign=\"middle\"><IMG border=0 height=120 src=\"/cdshop/logo.gif\" width=550></TD>\n" +
		  	"		</TR>\n" +
		  	"\n" +

		  	"		<TR>\n" +
		  	"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
		  	"		</TR>\n" +
		  	"\n");

		try
		{
			String url = "jdbc:odbc:cdshopDB";
			Connection con;
			Statement stmt;
			ResultSet rs;

			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			con = DriverManager.getConnection(url, "horst", "horst");

			out.println(
				"		<TR>\n" +
				"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Vielen Dank fr Ihre Bestellung</B></TD>\n" +
				"		</TR>\n" +
				"\n");

			out.println(
			"		<TR height=20 bgcolor=\"white\">\n" +
			"			<TD align=\"center\">Cover</TD>\n" +
			"			<TD align=\"center\">Titel</TD>\n" +
			"			<TD align=\"center\">Artist</TD>\n" +
			"			<TD align=\"center\">Anzahl</TD>\n" +
			"			<TD align=\"center\">Preis</TD>\n" +
			"			<TD align=\"center\">Entfernen</TD>\n" +
			"		</TR>\n" +
			"\n");

			double gesamtPreis = 0.0;
			double einzelPreis = 0.0;

			for (int i=0; i<cart.size(); i++)
			{
				ShoppingObject myObject = cart.getObject(i);

				stmt = con.createStatement();
				rs = stmt.executeQuery("SELECT id, cover, titel, artist, preis FROM Katalog WHERE id = " + myObject.getId());

				if(rs.next())
				{
					int id = rs.getInt("id");
					String cover = rs.getString("cover");
					String titel = rs.getString("titel");
					String artist = rs.getString("artist");
					double preis = rs.getDouble("preis");

					String enc_url = response.encodeUrl("CartServlet?remove=" + id);

					out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD align=\"center\" valign=\"middle\"><img src=\"/cdshop/" + cover + "\"></TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + titel + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + artist + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + myObject.getAnzahl() + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + preis + " DM</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\"><A href=\"" + enc_url +"\"><B>Entfernen</B></A></TD>\n" +
			"		</TR>\n");

					einzelPreis = preis;
				}

				gesamtPreis += einzelPreis * myObject.getAnzahl();
				rs.close();
				stmt.close();
			}

			// Gesamtsumme und Gesamtpreis ausgeben
			out.println(
			"		<TR bgcolor=\"white\">" +
			"           <TD align=\"center\">Gesamt</TD>" +
			"           <TD colspan=3>&nbsp;</TD>" +
			"			<TD align=\"center\">" + gesamtPreis + " DM</TD>" +
			"           <TD>&nbsp;</TD>" +
			"		</TR>" +
			"\n" +

			"		<TR>\n" +
			"			<TD bgcolor=\"#2D84A4\" colspan=6>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Sie haben " + cart.size() +
			" Artikel mit folgenden Daten bestellt:</B></TD>\n" +
			"		</TR>\n" +
			"\n");

			//Eingabeformular auslesen und in Datenbank schreiben
			Enumeration form = request.getParameterNames();
			StringBuffer bestellung = new StringBuffer();
			StringBuffer cTime = new StringBuffer();
			cTime.append(session.getCreationTime());

 			for (int i=0; i<cart.size(); i++)
			{
				ShoppingObject myObject = cart.getObject(i);
				bestellung.append("(" + myObject.getAnzahl() + "x" + myObject.getId() + ") ");
			}

			stmt = con.createStatement();

			String sql = "INSERT INTO Bestellungen (ort, email, name, strasse, bestellung, ctime) values ('" + (String) ( request.getParameter( (String) form.nextElement() ) ) + "', '" + (String) ( request.getParameter( (String) form.nextElement() ) ) + "', '" + (String) ( request.getParameter( (String) form.nextElement() ) ) + "', '" + (String) ( request.getParameter( (String) form.nextElement() ) ) + "', '" + bestellung.toString() + "', '"+ cTime.toString() + "')";

			int back = stmt.executeUpdate(sql);

			stmt.close();

   			//Ausgabe Kundendaten
			stmt = con.createStatement();
			rs = stmt.executeQuery("SELECT name, strasse, ort, email FROM Bestellungen WHERE ctime = '" + cTime.toString() + "'");

			String name = "";
			String strasse = "";
			String ort = "";
			String email = "";

			while (rs.next() )
			{
				name = rs.getString("name");
				strasse = rs.getString("strasse");
				ort = rs.getString("ort");
				email = rs.getString("email");
			}

			out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD valign=\"middle\">Name: </TD>\n" +
			"			<TD colspan=5 valign=\"middle\">" + name + "</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR bgcolor=\"silver\">\n" +
			"			<TD valign=\"middle\">Strae: </TD>\n" +
			"			<TD colspan=5 valign=\"middle\">" + strasse + "</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR bgcolor=\"silver\">\n" +
			"			<TD valign=\"middle\">PLZ und Ort: </TD>\n" +
			"			<TD colspan=5 valign=\"middle\">" + ort + "</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR bgcolor=\"silver\">\n" +
			"			<TD valign=\"middle\">EMail: </TD>\n" +
			"			<TD colspan=5 valign=\"middle\">" + email + "</TD>\n" +
			"		</TR>\n" +
			"\n");

			rs.close();
			stmt.close();

			//Bestellte CDs aus der Datenbank lschen.
			for (int i=0; i<cart.size(); i++)
			{
				//Auslesen
				ShoppingObject myObject = cart.getObject(i);
				int anzahlGes;
				int anzahlBest = myObject.getAnzahl();

				stmt = con.createStatement();
				rs = stmt.executeQuery("SELECT anzahl FROM Katalog WHERE id = " + myObject.getId());

				rs.next();
				anzahlGes = rs.getInt("anzahl");

				rs.close();
				stmt.close();

				//Zurckschreiben
				stmt = con.createStatement();

				back = stmt.executeUpdate("UPDATE Katalog SET anzahl = " + (anzahlGes - anzahlBest) + " WHERE id = " + myObject.getId());

				stmt.close();
			}

			//DB-Verbindungen beenden
			con.close();

			//Wagen leeren
			cart.clearAll();
			session.putValue(session.getId(), cart);

			//Links darstellen
			out.println(
				"		<TR>\n" +
				"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\"><A href=\"" +
								response.encodeUrl("KatalogServlet?filter=catalog") + "\"><B>Zum Katalog</B></A> | " + "<A href=\"" +
								response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A>" +
				"		</TR>\n" +
				"\n");

			out.println(
				"	</TABLE>\n" +
				"	</BODY>\n" +
				"</HTML>\n");

			//FileWriter beenden
			out.close();
		}

		catch (SQLException ex)
		{
			System.err.println("Fehler bei DB-Verbindung");
			out.println(
			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">Fehler bei der DB-Verbindung.\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
    	}

		catch (ClassNotFoundException ex)
		{
			System.err.println("DB-Treiber konnte nicht geladen werden");
			out.println(
			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">DB-Treiber konnte nicht geladen werden.</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
		}
	}
}
