// Autor: Horst Rechner

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class KasseServlet extends HttpServlet
{
	public void doGet (HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
    {
		PrintWriter out = response.getWriter();
		// Rckgabe MIME-Type festlegen
		response.setContentType("text/html");

		// aktuelle Session aus Request abfangen, gegebenfalls erzeugen
		HttpSession session = request.getSession(true);

		// in der akt. Session enthaltenes object cart wird in ShoppingCart bernommen
		ShoppingCart cart = (ShoppingCart)session.getValue(session.getId());

		// HTML-Dateikopf ausgeben
		out.println(
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
			"\n" +

			"<HTML>\n" +
			"	<HEAD>\n" +
			"		<TITLE>CD-Shopping ganz einfach - Kasse</TITLE>\n" +
			"       <META http-equiv=\"expires\" content=\"0\">\n" +
			"	</HEAD>\n" +
			"\n" +

			"	<BODY bgcolor=\"#2D84A4\" text=\"black\" link=\"white\" vlink=\"white\" alink=\"#2D84A4\">\n" +
			"	<TABLE border=0 width=\"100%\">\n" +
			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" valign=\"middle\"><IMG border=0 height=120 src=\"/cdshop/logo.gif\" width=550></TD>\n" +
			"		</TR>\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n");

		//Artikel in Einkaufwagen
		out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Sie haben " + cart.size() +
			" Artikel in ihrem Einkaufwagen</B></TD>\n" +
			"		</TR>\n" +
			"\n");

		//Eingabeformular
		out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD colspan=6>\n" +
			"				<FORM method=\"post\" action=\"/servlet/" + response.encodeUrl("DankeServlet") + "\">\n" +
			"					<TABLE align=\"center\">\n" +
			"						<TR>\n"+
			"							<TD>Ihr Name:</TD>\n" +
			"							<TD><INPUT type=text name=\"name\" size=60></TD>\n" +
			"						</TR>\n" +
			"\n"+

			"						<TR>\n"+
			"							<TD>Strae:</TD>\n" +
			"							<TD><INPUT type=text name=\"strasse\" size=60></TD>\n" +
			"						</TR>\n" +
			"\n"+

			"						<TR>\n"+
			"							<TD>PLZ und Ort:</TD>\n" +
			"							<TD><INPUT type=text name=\"ort\" size=60></TD>\n" +
			"						</TR>\n" +
			"\n"+

			"						<TR>\n"+
			"							<TD>EMail:</TD>\n" +
			"							<TD><INPUT type=text name=\"email\" size=60></TD>\n" +
			"						</TR>\n" +
			"\n"+

			"						<TR>\n"+
			"							<TD>Abschicken:</TD>\n" +
			"							<TD><INPUT type=submit value=\"Bestellung abschicken\"></TD>\n" +
			"						</TR>\n" +
			"\n"+

			"                   </TABLE>\n" +
			"				</FORM>\n" +
			"           </TD>\n" +
			"		</TR>\n");

		//Links darstellen
		out.println(
			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\"><A href=\"" +
							response.encodeUrl("KatalogServlet?filter=catalog") + "\"><B>Zum Katalog</B></A> | " + "<A href=\"" +
							response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A> | <A href=\"" +
							response.encodeUrl("CartServlet") + "\"><B>Zum Einkaufswagen</B></A></TD>\n" +
			"		</TR>\n" +
			"\n");

		out.println(
			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

		//FileWriter beenden
		out.close();
	}
}
