// Autoren: Robert Ssemann und Horst Rechner

import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;


public class KatalogServlet extends HttpServlet
{
	public void doGet (HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		PrintWriter out = response.getWriter();
		// Rckgabe MIME-Type festlegen
		response.setContentType("text/html");

		// aktuelle Session aus Request abfangen, gegebenfalls erzeugen
		HttpSession session = request.getSession(true);

		// in der akt. Session enthaltenes object cart wird in ShoppingCart bernommen
		ShoppingCart cart = (ShoppingCart)session.getValue(session.getId());

		if (cart == null)
		{
			// erzeugt neues cart
			cart = new ShoppingCart();
			// Bindet das Object cart an die aktuelle Session
			session.putValue(session.getId(), cart);
		}

		// HTML-Dateikopf ausgeben
		out.println(
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
			"\n" +

			"<HTML>\n" +
			"	<HEAD>\n" +
			"		<TITLE>CD-Shopping ganz einfach - Katalog</TITLE>\n" +
			"       <META http-equiv=\"expires\" content=\"0\">\n" +
			"	</HEAD>\n" +
			"\n" +

			"	<BODY bgcolor=\"#2D84A4\" text=\"black\" link=\"white\" vlink=\"white\" alink=\"white\">\n" +
			"	<TABLE border=0 width=\"100%\">\n" +
			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" valign=\"middle\"><IMG border=0 height=120 src=\"/cdshop/logo.gif\" width=550></TD>\n" +
			"		</TR>\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n");

		//je nach Filterparameter DB auslesen
		String filter = request.getParameter("filter");

		try
		{
			String url = "jdbc:odbc:cdshopDB";
			Connection con;
			Statement stmt;
			ResultSet rs;

			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			con = DriverManager.getConnection(url, "horst", "horst");

			//Katalog je nach Filter auslesen

			if(filter.equals("catalog"))
			{
				stmt = con.createStatement();
				rs = stmt.executeQuery("SELECT id, cover, titel, artist, beschreibung, preis FROM Katalog");

				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Unser CD Angebot</B></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR height=20 bgcolor=\"white\">\n" +
			"			<TD align=\"center\">Cover</TD>\n" +
			"			<TD align=\"center\">Titel</TD>\n" +
			"			<TD align=\"center\">Artist</TD>\n" +
			"			<TD align=\"center\">Beschreibung</TD>\n" +
			"			<TD align=\"center\">Preis</TD>\n" +
			"			<TD align=\"center\">Bestellen</TD>\n" +
			"		</TR>\n");

				while (rs.next())
				{
					int id = rs.getInt("id");
					String cover = rs.getString("cover");
					String titel = rs.getString("titel");
					String artist = rs.getString("artist");
					String beschreibung = rs.getString("beschreibung");
					double preis = rs.getDouble("preis");

					String enc_url = response.encodeUrl("KatalogServlet?add=" + id +"&filter=catalog");

					out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD align=\"center\" valign=\"middle\"><img src=\"/cdshop/" + cover + "\"></TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + titel + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + artist + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + beschreibung + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + preis + " DM</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\"><A href=\"" + enc_url +"\"><B>ein Exemplar</B></A>\n" +
			"		</TR>\n");
				}

				rs.close();
				stmt.close();
      		}

			if(filter.equals("news"))
			{
				stmt = con.createStatement();
				rs = stmt.executeQuery("SELECT id, cover, titel, artist, beschreibung, preis FROM Katalog WHERE neu = 1");

				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Unsere Neuerscheinungen</B></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR height=20 bgcolor=\"white\">\n" +
			"			<TD align=\"center\">Cover</TD>\n" +
			"			<TD align=\"center\">Titel</TD>\n" +
			"			<TD align=\"center\">Artist</TD>\n" +
			"			<TD align=\"center\">Beschreibung</TD>\n" +
			"			<TD align=\"center\">Preis</TD>\n" +
			"			<TD align=\"center\">Bestellen</TD>\n" +
			"		</TR>\n" +
			"\n");

				while (rs.next())
				{
					int id = rs.getInt("id");
					String cover = rs.getString("cover");
					String titel = rs.getString("titel");
					String artist = rs.getString("artist");
					String beschreibung = rs.getString("beschreibung");
					double preis = rs.getDouble("preis");

					String enc_url = response.encodeUrl("KatalogServlet?add=" + id +"&filter=news");

					out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD align=\"center\" valign=\"middle\"><img src=\"/cdshop/" + cover + "\"></TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + titel + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + artist + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + beschreibung + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + preis + " DM</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\"><A href=\"" + enc_url +"\"><B>ein Exemplar</B></A>\n" +
			"		</TR>\n");
				}

    			rs.close();
				stmt.close();
  			}

			if(filter.equals("admin"))
			{
				stmt = con.createStatement();
				rs = stmt.executeQuery("SELECT id, cover, titel, artist, beschreibung, preis FROM Katalog WHERE anzahl < 5");

				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\"><B>Bei folgenden CD's sind nur weniger als 5 Stck im Lager</B></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR height=20 bgcolor=\"white\">\n" +
			"			<TD align=\"center\">Cover</TD>\n" +
			"			<TD align=\"center\">Titel</TD>\n" +
			"			<TD align=\"center\">Artist</TD>\n" +
			"			<TD align=\"center\">Beschreibung</TD>\n" +
			"			<TD align=\"center\">Preis</TD>\n" +
			"		</TR>\n" +
			"\n");

				while (rs.next())
				{
					int id = rs.getInt("id");
					String cover = rs.getString("cover");
					String titel = rs.getString("titel");
					String artist = rs.getString("artist");
					String beschreibung = rs.getString("beschreibung");
					double preis = rs.getDouble("preis");

					out.println(
			"		<TR bgcolor=\"silver\">\n" +
			"			<TD align=\"center\" valign=\"middle\"><img src=\"/cdshop/" + cover + "\"></TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + titel + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + artist + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + beschreibung + "</TD>\n" +
			"			<TD align=\"center\" valign=\"middle\">" + preis + " DM</TD>\n" +
			"		</TR>\n");
				}

    			rs.close();
				stmt.close();
      		}

		    String addString = request.getParameter("add");
			Integer addInt;

			if (addString != null)
			{
				addInt = new Integer(addString);
			}
			else
			{
				addInt = new Integer(-1);
			}

			if(addInt.intValue() > 0)
			{
				cart.add(addInt.intValue());
				session.putValue(session.getId(), cart);
			}

			if (cart.size() > 0)
			{
				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">\n" +
			"				<A href=\"" + response.encodeUrl("CartServlet") + "\"><B>Einkaufswagen einsehen</B></A> | " + "<A href=\"" + response.encodeUrl("KasseServlet") + "\"><B>Kasse</B></A> | " + "<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n");
			}

			else
			{
				out.println(
			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n");
        	}

			out.println(
			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//DB-Verbindungen beenden
			con.close();
			//FileWriter beenden
			out.close();
		}

		catch (SQLException ex)
		{
			System.err.println("Fehler bei DB-Verbindung");
			out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\">&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">Fehler bei der DB-Verbindung.\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
    	}

		catch (ClassNotFoundException ex)
		{
			System.err.println("DB-Treiber konnte nicht geladen werden");
			out.println(
			"		<TR>\n" +
			"			<TD colspan=6 bgcolor=\"#EDB211\">&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD bgcolor=\"red\" colspan=6 align=\"center\" valign=\"middle\">DB-Treiber konnte nicht geladen werden.</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=6 align=\"center\" bgcolor=\"#EDB211\">" +
			"<A href=\"" + response.encodeUrl("MainServlet") + "\"><B>zum Hauptmenue</B></A></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
		}
    }
}
