// Autoren: Robert Ssemann und Horst Rechner

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class MainServlet extends HttpServlet
{
	public void doGet(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException
	{
		PrintWriter out = response.getWriter();
		// Rckgabe MIME-Type festlegen
    	response.setContentType("text/html");

		// aktuelle Session aus Request abfangen, gegebenfalls erzeugen
		HttpSession session = request.getSession(true);
		// in der akt. Session enthaltenes object cart wird in ShoppingCart bernommen
		ShoppingCart cart = (ShoppingCart)session.getValue(session.getId());

		if (cart == null)
		{
			// erzeugt neues cart
			cart = new ShoppingCart();
			// Bindet das Object cart an die aktuelle Session
			session.putValue(session.getId(), cart);
		}

		out.println(
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n" +
			"\n" +

			"<HTML>\n" +
			"	<HEAD>\n" +
			"		<TITLE>CD-Shopping ganz einfach - Start</TITLE>\n" +
			"	</HEAD>\n" +
			"\n" +

			"	<SCRIPT language=\"javascript\">\n" +
			"	<!--\n" +
			"	function login()\n" +
			"	{\n" +
			"		pw = prompt(\"Admin-Passwort eingeben\",\"\");\n" +
			"		if (pw == \"admin\") document.location = \"" +
						response.encodeUrl("KatalogServlet?filter=admin") + "\"" +
			"\n" +

			"	}\n" +
			"	//-->\n" +
			"	</SCRIPT>\n" +

			"\n" +
			"\n" +
			"	<BODY bgcolor=\"#2D84A4\" text=\"White\" link=\"#EDB211\" vlink=\"#EDB211\" alink=\"white\">\n" +
			"	<TABLE border=0 width=\"100%\">\n" +
			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" align=\"center\" valign=\"middle\"><IMG alt=\"\" border=0 height=120 src=\"/cdshop/logo.gif\" width=550></TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD>&nbsp;</TD>\n" +
			"			<TD colspan=4 bgcolor=\"#EDB211\">&nbsp;</TD>\n" +
			"			<TD>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD>&nbsp;</TD>\n" +
			"			<TD align=\"center\" valign=\"top\"><A href=\"" +
							response.encodeUrl("KatalogServlet?filter=catalog") + "\"><IMG src=\"/cdshop/catalog.gif\" width=100 height=100 border=0 alt=\"Gesamtkatalog\"></A><BR>Unser Gesamtangebot an CDs</TD>\n" +
			"			<TD align=\"center\" valign=\"top\"><A href=\"" +
							response.encodeUrl("KatalogServlet?filter=news") + "\"><IMG src=\"/cdshop/news.gif\" width=100 height=100 border=0 alt=\"Neuheiten\"></A><BR>Aktuelle CD-Neuerscheinungen</TD>\n" +
			"			<TD align=\"center\" valign=\"top\"><A href=\"" +
							response.encodeUrl("CartServlet") + "\"><IMG src=\"/cdshop/cart.gif\" width=100 height=100 border=0 alt=\"Einkaufswagen\"></A><BR>Ihr aktueller Inhalt im Warenkorb</TD>\n" +
			"			<TD align=\"center\" valign=\"top\"><A href=\"javascript:login()\"><IMG src=\"/cdshop/admin.gif\" width=100 height=100 border=0 alt=\"Hndler Login\"></A><BR>Passwortgeschtzter Hndlerlogin</TD>\n" +
			"			<TD>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD width=\"125\">&nbsp;</TD>\n" +
			"			<TD align=\"center\" bgcolor=\"#EDB211\"><b>Gesamtkatalog</b></TD>\n" +
			"			<TD align=\"center\" bgcolor=\"#EDB211\"><b>Neuheiten</b></TD>\n" +
			"			<TD align=\"CENTER\" bgcolor=\"#EDB211\"><b>Einkaufswagen</b></TD>\n" +
			"			<TD align=\"CENTER\" bgcolor=\"#EDB211\"><b>H&auml;ndler-LogIn</b></TD>\n" +
			"			<TD width=\"125\">&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR>\n" +
			"			<TD colspan=\"6\" height=30>&nbsp;</TD>\n" +
			"		</TR>\n" +
			"\n" +

			"		<TR valign=\"bottom\">\n" +
			"			<TD colspan=\"3\" align=\"left\"><SMALL><SMALL>Vorlesung PROGRAMMIEREN IM INTERNET WS99/00</SMALL></SMALL></TD>\n" +
			"			<TD colspan=\"3\" align=\"right\"><SMALL><SMALL>Servlet Projekt  1/2000 von <A href=\"mailto:robert.soesemann@student.uni-tuebingen.de\">R. Ssemann</A> und <A href=\"mailto:horst.rechner@gmx.de\">H. Rechner</A></SMALL></SMALL></TD>\n" +
			"		</TR>\n" +
			"	</TABLE>\n" +
			"	</BODY>\n" +
			"</HTML>\n");

			//FileWriter beenden
			out.close();
        }
}
