// Autor: Horst Rechner

import java.util.*;

public class ShoppingCart
{
	private Vector shoppingList = new Vector();

	public ShoppingCart()
	{}

	public int getAnzahl(int ofId)
	{
		int returnAnzahl = -1;
		int position = searchId(ofId);

		if (position > -1)
		{
			ShoppingObject myObject = (ShoppingObject)shoppingList.elementAt(position);
			returnAnzahl = myObject.getAnzahl();
		}

		return returnAnzahl;
	}

	public ShoppingObject getObject(int position)
	{
		if ( (position >= 0) && (position < size()) )
		{
			ShoppingObject myObject = (ShoppingObject)shoppingList.elementAt(position);
			return myObject;
		}
		else
		{
			ShoppingObject myObject = new ShoppingObject(-1, -1);
			return myObject;
		}
	}

	public int size()
	{
		return shoppingList.size();
	}

	public void clearAll()
	{
		shoppingList.removeAllElements();
	}

	private int searchId(int intId)
	{
		int position = -1;

		if(this.size() != 0)
		{
			for(int i=0; i<this.size(); i++)
			{
				ShoppingObject myObject = (ShoppingObject)shoppingList.elementAt(i);
				if (intId == myObject.getId()) position = i;
			}
		}

		return position;
	}

	public void add(int intId, int intAnzahl)
	{
		int found = searchId(intId);

		if (intAnzahl < 1) intAnzahl = 1;

		if(found == -1)
		{
			shoppingList.addElement(new ShoppingObject(intId, intAnzahl));
		}
		else
		{
			ShoppingObject myObject = (ShoppingObject)shoppingList.elementAt(found);
			int newAnzahl = myObject.getAnzahl()+intAnzahl;
			myObject.setAnzahl(newAnzahl);
			shoppingList.setElementAt(myObject, found);
		}
	}

	public void add(int intId)
	{
		add(intId, 1);
	}

	public void removeId(int intId)
	{
		int found = searchId(intId);
		ShoppingObject myObject = (ShoppingObject)shoppingList.elementAt(found);

		if(myObject.getAnzahl() == 1)
		{
			shoppingList.removeElementAt(found);
		}
		else
		{
			int newAnzahl = myObject.getAnzahl();
			myObject.setAnzahl(newAnzahl-1);
			shoppingList.setElementAt(myObject, found);
		}
    }
}
